function range_markers(start,sample_size,period_us)
{
  // 500khs = 2 microseconds
  var x = [];
  var k=start;
  for (var i=1;i<=sample_size;i++) {
    x.push(k);
    k += period_us;
  }
  return x;
}

function expand_array(start,x)
{
  var pad_sz = x[0];
  for ( var i=start; i < pad_sz; i++ )
  {
    x.unshift(0);
  }
  return x;
}

function renderWave(obj,name)
{
  if ( obj != null )
  {
    // charts
    new Chart(name, {
      type: "line",
      data: {
        labels: range_markers(obj.start,obj.raw.length,obj.period),
        datasets: [{ 
          data: expand_array(obj.start,obj.cooked),
          options: {
            scales: {
              x: {
                beginAtZero: true
              }
            }
          },
          borderColor: "red",
          pointStyle: false,
          pointRadius: 1,
        },{
          data: obj.raw,
          options: {
            scales: {
              x: {
                beginAtZero: true
              }
            }
          },
          borderColor: "green",
          pointStyle: false,
          pointRadius: 1,
        },{
          data: expand_array(obj.start,obj.marker),
          options: {
            scales: {
              x: {
                beginAtZero: true
              }
            }
          },
          borderColor: "blue",
          pointStyle: false,
          pointRadius: 1,
        }]
      },
      options: {
        legend: {display: false}
      }
    });
    // forms
    document.getElementById(name+'_detect').value = obj.detect;
  }
}

function loadWave(name){
  var obj=null;
  var request = new XMLHttpRequest();
  request.onreadystatechange = function(){
    if(request.readyState == 4){
      if(request.status == 200){
        obj=JSON.parse(request.responseText);
        renderWave(obj,name);
      }else{
        console.log("Status error: "+request.status);
      }
    }
  }
  request.open('GET','http://'+location.hostname+'/sys/'+name+'.jsn');
  request.send();
}

function loadWaveforms(){
  loadWave('wave1');
  loadWave('wave2');
}

function loadPage(){
  loadWaveforms();
  /* setInterval(loadWaveforms, 30000); */
}

function goPage(page){
  var url='http://'+location.hostname+'/'+page+'.htm';
  window.location.replace(url);
}
