var xLoad='system';
var xRequest;
var xObj;
var xButton;
var xJSON;
var xMsg='Saved';

function isNumeric(num){
  return !isNaN(num)
}

function initStoreSystemSettings(){
  xButton = document.getElementById("btn_store");
  xButton.addEventListener("click",storeSystemSettings);
}

function storeSystemSettings(){
  var storeObj = fetchSettings(xObj);
  xRequest = new XMLHttpRequest();
  xRequest.onerror = function(){
    alert(`Network Error: `+xRequest.responseText);
  }
  xRequest.onload = function(){
    if (xRequest.status != 200) {
      alert(`Error ${xRequest.status}: ${xRequest.statusText}`);
    } else {
      alert(`[${xRequest.response.length}]  `+xMsg+'!');
    }    
  }
  xJSON = JSON.stringify(storeObj,null,4);
  xRequest.open('POST','http://'+location.hostname+'/post.htm');
  xRequest.setRequestHeader('Content-type', 'application/json; charset=utf-8');
  xRequest.send(xJSON);
}

function loadSystemSettings(){
  xRequest = new XMLHttpRequest();
  xRequest.onreadystatechange = function(){
    if(xRequest.readyState == 4){
      if(xRequest.status == 200){
        xObj=JSON.parse(xRequest.responseText);
        if ( xObj.id == xLoad ){
          editSettings(xObj);
          initStoreSystemSettings();
        }else{
          alert("Expected id="+xLoad+", settings are invalid.");
        }
      }else{
        console.log("Status error: "+xRequest.status);
      }
    }
  }
  xRequest.open('GET','http://'+location.hostname+'/sys/'+xLoad+'.jsn');
  xRequest.send();
}

function loadResetSettings(){
  xLoad='reset';
  xMsg='Reset';
  loadSystemSettings();
}

function loadXPairSettings(){
  xLoad='xpair0';
  loadSystemSettings();
}

function goPage(page){
  var url='http://'+location.hostname+'/'+page+'.htm';
  window.location.replace(url);
}
